# -*- coding: utf-8 -*-
"""
Created on Tue Oct 10 16:04:34 2023

@author: LocalAdmin
"""
# from yade import pack, plot
import matplotlib.pyplot as plt
from matplotlib.pyplot import MultipleLocator
import matplotlib.ticker as ticker
import numpy as np
import pandas as pd

font1 = {'family': 'Times New Roman', 'weight': 'bold', 'size': 14, 'style':'normal'}

fig , ax = plt.subplots(figsize=(3.25,3))
bwith = 0.5# here control the width of axis
ax.spines['bottom'].set_linewidth(bwith)
# ax.spines['bottom'].set_color('black')
ax.spines['left'].set_linewidth(bwith)
# ax.spines['left'].set_color('black')
ax.spines['top'].set_linewidth(bwith)
# ax.spines['top'].set_color('black')
ax.spines['right'].set_linewidth(bwith)
# ax.spines['right'].set_color('black')


fname1="tryDis-100kPa.ipe"
fname2="tryDis-200kPa.ipe"
fname3="tryDis-300kPa.ipe"

def plot_q_e1(fname):
    ### this function is for plotting the stress - axial strain curve.
    sigYY_list=[]
    sigXX_list=[]
    time_list=[]
    epsXX_list=[]
    epsYY_list=[]
    with open(fname) as f:
        next(f)## skip the 1st line
        for line in f:
            time=line[31:42]
            time_list.append(float(time))
            
            sigyy=line[119:131]
            # print (time), print (float(time))
            sigYY_list.append(float(sigyy))
            
            sigxx=line[77:89]
            # print (sigxx,float(sigxx))
            sigXX_list.append(float(sigxx))
            
            epsxx=line[161:173]
            epsXX_list.append(float(epsxx))
            
            epsyy=line[202:311]
            # print (epsyy,float(epsyy))
            epsYY_list.append(float(epsyy))
    
    q=np.array(sigYY_list)-np.array(sigXX_list)

    
    # ax.plot(-np.array(epsYY_list)*100,np.array(q)/1000,'k',linestyle="-",label="q",linewidth=2,alpha=1)
    ax.plot(-np.array(epsYY_list)*100,np.array(q)/1000,label=fname[-10:-5],linewidth=2,alpha=1)
    # ax.plot(-np.array(epsYY_list)*100,np.array(epsV)/1000,'k',linestyle=":",label="q",linewidth=2,alpha=1)

plot_q_e1(fname1)
plot_q_e1(fname2)
plot_q_e1(fname3)

# =============================================================================
#                   Figure setting
#1 set legend
ax.legend(loc=0,frameon=False,prop={'family': 'Times New Roman','size': 9})
# plt.legend(loc=0,prop={'size': 6})
#2 set xy label
ax.set_xlabel('Axial strain, (%)',font1)
# ax.set_xlabel('Axial strain, $\mathregular{\epsilon_1}$ (%)',font1)

ax.set_ylabel('Deviatoric stress, $\mathregular{q} $ (kPa)',font1)
#3 set  xy tick, range
# ax.tick_params(which='both', width=0.5)
# ax.tick_params(which='major', length=5)
ax.tick_params(which='both',labelsize=10,direction='in')
plt.xticks(fontproperties = 'Times New Roman', size = 12)
plt.yticks(fontproperties = 'Times New Roman', size = 12)
# plt.ylim(0,1200)
# plt.xlim(0,40)

# ax.xaxis.set_major_locator(ticker.MultipleLocator(5))
# ax.xaxis.set_minor_locator(ticker.MultipleLocator(2.5))
# ax.yaxis.set_major_locator(ticker.MultipleLocator(200))
# ax.yaxis.set_minor_locator(ticker.MultipleLocator(100))

plt.tight_layout(pad=0.4)
# # plt.savefig('{}_4type_stress.png'.format(key), dpi=600)
plt.show()

########################################################
########################################################
########################################################

font1 = {'family': 'Times New Roman', 'weight': 'bold', 'size': 14, 'style':'normal'}

fig , ax = plt.subplots(figsize=(3.25,3))
bwith = 0.5# here control the width of axis
ax.spines['bottom'].set_linewidth(bwith)
# ax.spines['bottom'].set_color('black')
ax.spines['left'].set_linewidth(bwith)
# ax.spines['left'].set_color('black')
ax.spines['top'].set_linewidth(bwith)
# ax.spines['top'].set_color('black')
ax.spines['right'].set_linewidth(bwith)
# ax.spines['right'].set_color('black')



def plot_ev_e1(fname):
    ### this function is for plotting the volumetric strain- axial strain curve.
    sigYY_list=[]
    sigXX_list=[]
    time_list=[]
    epsXX_list=[]
    epsYY_list=[]
    with open(fname) as f:
        next(f)## skip the 1st line
        for line in f:
            time=line[31:42]
            time_list.append(float(time))
            
            sigyy=line[119:131]
            # print (time), print (float(time))
            sigYY_list.append(float(sigyy))
            
            sigxx=line[77:89]
            # print (sigxx,float(sigxx))
            sigXX_list.append(float(sigxx))
            
            epsxx=line[161:173]
            epsXX_list.append(float(epsxx))
            
            epsyy=line[202:311]
            # print (epsyy,float(epsyy))
            epsYY_list.append(float(epsyy))
    
    q=np.array(sigYY_list)-np.array(sigXX_list)
    epsV=2*np.array(epsXX_list)+np.array(epsYY_list)
    ### note that, due to the axisymetric problem, epsXX should times 2 to account for the epsZZ.
    

    ax.plot(-np.array(epsYY_list)*100,-np.array(epsV)*100,label=fname[-10:-5],linewidth=2,alpha=1)

plot_ev_e1(fname1)
plot_ev_e1(fname2)
plot_ev_e1(fname3)
# =============================================================================
#                   Figure setting
#1 set legend
ax.legend(loc=0,frameon=False,prop={'family': 'Times New Roman','size': 9})
# plt.legend(loc=0,prop={'size': 6})
#2 set xy label
ax.set_xlabel('Axial strain, (%)',font1)
# ax.set_xlabel('Axial strain, $\mathregular{\epsilon_1}$ (%)',font1)

ax.set_ylabel('Volumetric strain (%)',font1)
#3 set  xy tick, range
# ax.tick_params(which='both', width=0.5)
# ax.tick_params(which='major', length=5)
ax.tick_params(which='both',labelsize=10,direction='in')
plt.xticks(fontproperties = 'Times New Roman', size = 12)
plt.yticks(fontproperties = 'Times New Roman', size = 12)
# plt.ylim(0,1200)
# plt.xlim(0,40)

# ax.xaxis.set_major_locator(ticker.MultipleLocator(5))
# ax.xaxis.set_minor_locator(ticker.MultipleLocator(2.5))
# ax.yaxis.set_major_locator(ticker.MultipleLocator(200))
# ax.yaxis.set_minor_locator(ticker.MultipleLocator(100))

plt.tight_layout(pad=0.4)
# # plt.savefig('{}_4type_stress.png'.format(key), dpi=600)
plt.show()
